/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.instances.ItemPartEffector;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartEffector;
import minecrafttransportsimulator.packloading.PackMaterialComponent;

public class PartEffector
extends APart {
    private final List<PartInteractable> linkedPullableCrates = new ArrayList<PartInteractable>();
    private final List<PartInteractable> linkedPushableCrates = new ArrayList<PartInteractable>();
    private final List<IWrapperItemStack> drops = new ArrayList<IWrapperItemStack>();
    private final Map<IWrapperEntity, IWrapperItemStack> entityItems = new HashMap<IWrapperEntity, IWrapperItemStack>();
    public int blocksBroken;
    public boolean activatedThisTick;
    private final Point3D flooredCenter = new Point3D();
    private final Map<BoundingBox, Point3D> boxLastPositionsFloored = new HashMap<BoundingBox, Point3D>();
    private final Map<BoundingBox, Integer> boxTimeSpentAtPosition = new HashMap<BoundingBox, Integer>();
    private final Set<Point3D> blockFlooredPositionsBrokeThisTick = new HashSet<Point3D>();
    private int operationDelay;
    private final List<PackMaterialComponent> inputMaterials = new ArrayList<PackMaterialComponent>();
    private final List<PackMaterialComponent> outputMaterials = new ArrayList<PackMaterialComponent>();

    public PartEffector(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartEffector item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (data != null) {
            this.blocksBroken = data.getInteger("blocksBroken");
        }
        if (((JSONPart)this.definition).effector.type == JSONPart.EffectorComponentType.CRAFTER) {
            ((JSONPart)this.definition).effector.crafterInputs.forEach(input -> {
                PackMaterialComponent material = new PackMaterialComponent((String)input);
                if (material.possibleItems.isEmpty()) {
                    InterfaceManager.coreInterface.logError("ERROR: Crafter of type " + this.definition + " is set with a material input of " + input + " but that's not a valid item.  Contact your modpack, or pack author as this input is being skipped!");
                } else {
                    this.inputMaterials.add(material);
                }
            });
            ((JSONPart)this.definition).effector.crafterOutputs.forEach(output -> {
                PackMaterialComponent material = new PackMaterialComponent((String)output);
                if (material.possibleItems.isEmpty()) {
                    InterfaceManager.coreInterface.logError("ERROR: Crafter of type " + this.definition + " is set with a material output of " + output + " but that's not a valid item.  Contact your modpack, or pack author as this output is being skipped!");
                } else {
                    this.outputMaterials.add(material);
                }
            });
        }
    }

    @Override
    public void update() {
        super.update();
        this.activatedThisTick = false;
        this.operationDelay = this.operationDelay < ((JSONPart)this.definition).effector.operationDelay ? ++this.operationDelay : 0;
        if (this.isActive && !this.world.isClient() && !this.outOfHealth && this.operationDelay == ((JSONPart)this.definition).effector.operationDelay) {
            this.drops.clear();
            this.entityItems.clear();
            this.blockFlooredPositionsBrokeThisTick.clear();
            for (BoundingBox box : this.collisionBoxes) {
                if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.EFFECTOR)) continue;
                block0 : switch (((JSONPart)this.definition).effector.type) {
                    case FERTILIZER: {
                        block14: for (PartInteractable crate : this.linkedPullableCrates) {
                            if (!crate.isActive) continue;
                            for (int i = 0; i < crate.inventory.getSize(); ++i) {
                                IWrapperItemStack stack = crate.inventory.getStack(i);
                                if (!this.world.fertilizeBlock(box.globalCenter, stack)) continue;
                                crate.inventory.removeFromSlot(i, 1);
                                this.activatedThisTick = true;
                                continue block14;
                            }
                        }
                        break;
                    }
                    case HARVESTER: {
                        List<IWrapperItemStack> blockDrops = this.world.harvestBlock(box.globalCenter);
                        if (blockDrops.isEmpty()) break;
                        this.drops.addAll(blockDrops);
                        this.activatedThisTick = true;
                        break;
                    }
                    case PLANTER: {
                        block16: for (PartInteractable crate : this.linkedPullableCrates) {
                            if (!crate.isActive) continue;
                            for (int i = 0; i < crate.inventory.getSize(); ++i) {
                                IWrapperItemStack stack = crate.inventory.getStack(i);
                                if (!this.world.plantBlock(box.globalCenter, stack)) continue;
                                crate.inventory.removeFromSlot(i, 1);
                                this.activatedThisTick = true;
                                continue block16;
                            }
                        }
                        break;
                    }
                    case PLOW: {
                        if (!this.world.plowBlock(box.globalCenter)) break;
                        this.activatedThisTick = true;
                        List<IWrapperItemStack> harvestedDrops = this.world.harvestBlock(box.globalCenter);
                        if (harvestedDrops.isEmpty()) break;
                        for (IWrapperItemStack stack : harvestedDrops) {
                            if (stack.getSize() <= 0) continue;
                            this.world.spawnItemStack(stack, this.position, null);
                        }
                        break;
                    }
                    case SNOWPLOW: {
                        if (!this.world.removeSnow(box.globalCenter)) break;
                        this.activatedThisTick = true;
                        break;
                    }
                    case DRILL: {
                        float blockHardness;
                        if (!this.world.isAir(box.globalCenter) && (blockHardness = this.world.getBlockHardness(box.globalCenter)) <= ((JSONPart)this.definition).effector.drillHardness) {
                            if (!this.boxLastPositionsFloored.containsKey(box)) {
                                this.boxLastPositionsFloored.put(box, new Point3D());
                                this.boxTimeSpentAtPosition.put(box, 0);
                            }
                            this.flooredCenter.set(Math.floor(box.globalCenter.x), Math.floor(box.globalCenter.y), Math.floor(box.globalCenter.z));
                            if (this.boxLastPositionsFloored.get(box).equals(this.flooredCenter) && !this.blockFlooredPositionsBrokeThisTick.contains(this.flooredCenter)) {
                                int timeSpentBreaking = this.boxTimeSpentAtPosition.get(box);
                                if ((float)timeSpentBreaking >= ((JSONPart)this.definition).effector.drillSpeed * blockHardness / ((JSONPart)this.definition).effector.drillHardness) {
                                    this.drops.addAll(this.world.getBlockDrops(this.flooredCenter));
                                    this.world.destroyBlock(this.flooredCenter, false);
                                    this.boxTimeSpentAtPosition.put(box, 0);
                                    this.blockFlooredPositionsBrokeThisTick.add(this.flooredCenter.copy());
                                    if (++this.blocksBroken == ((JSONPart)this.definition).effector.drillDurability) {
                                        this.remove();
                                    } else {
                                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEffector(this, true));
                                    }
                                    this.activatedThisTick = true;
                                    break;
                                }
                                this.boxTimeSpentAtPosition.put(box, timeSpentBreaking + 1);
                                break;
                            }
                            this.boxLastPositionsFloored.put(box, this.flooredCenter.copy());
                        }
                        this.boxTimeSpentAtPosition.put(box, 0);
                        break;
                    }
                    case PLACER: {
                        if (!this.world.isAir(box.globalCenter)) break;
                        for (PartInteractable crate : this.linkedPullableCrates) {
                            if (crate.isActive) {
                                for (int i = 0; i < crate.inventory.getSize(); ++i) {
                                    IWrapperItemStack stack = crate.inventory.getStack(i);
                                    if (!this.world.placeBlock(box.globalCenter, stack)) continue;
                                    crate.inventory.removeFromSlot(i, 1);
                                    this.activatedThisTick = true;
                                    break;
                                }
                            }
                            if (!this.activatedThisTick) continue;
                            break block0;
                        }
                        break;
                    }
                    case COLLECTOR: {
                        this.world.populateItemStackEntities(this.entityItems, box);
                        this.drops.addAll(this.entityItems.values());
                        break;
                    }
                    case DROPPER: {
                        boolean placedItem = false;
                        for (PartInteractable crate : this.linkedPullableCrates) {
                            if (crate.isActive) {
                                for (int i = 0; i < crate.inventory.getSize(); ++i) {
                                    IWrapperItemStack stack = crate.inventory.getStack(i);
                                    if (stack.isEmpty()) continue;
                                    IWrapperItemStack stackToDrop = stack.copy();
                                    stackToDrop.add(-stackToDrop.getSize() + 1);
                                    crate.inventory.removeFromSlot(i, 1);
                                    this.world.spawnItemStack(stackToDrop, box.globalCenter, new Point3D(Math.random() * 0.2 - 0.1, -0.2, Math.random() * 0.2 - 0.1).rotate(this.orientation));
                                    this.activatedThisTick = true;
                                    placedItem = true;
                                    break;
                                }
                            }
                            if (!placedItem) continue;
                            break block0;
                        }
                        break;
                    }
                    case SPRAYER: {
                        box.globalCenter.y -= 1.0;
                        this.world.hydrateBlock(box.globalCenter);
                        box.globalCenter.y += 1.0;
                        break;
                    }
                    case CRAFTER: {
                        if (this.outputMaterials.isEmpty()) break;
                        for (PartInteractable crate : this.linkedPullableCrates) {
                            if (!crate.isActive || !crate.inventory.hasMaterials(this.inputMaterials)) continue;
                            crate.inventory.removeMaterials(this.inputMaterials);
                            this.outputMaterials.forEach(material -> this.drops.add(material.possibleItems.get(0).copy()));
                            break block0;
                        }
                        break;
                    }
                }
                if (this.drops.isEmpty()) continue;
                Iterator<IWrapperItemStack> iterator = this.drops.iterator();
                block24: while (iterator.hasNext()) {
                    IWrapperItemStack dropStack = iterator.next();
                    for (PartInteractable crate : this.linkedPushableCrates) {
                        if (!crate.isActive) continue;
                        if (((JSONPart)this.definition).effector.type == JSONPart.EffectorComponentType.COLLECTOR && crate.inventory.addStack(dropStack, dropStack.getSize(), false)) {
                            this.activatedThisTick = true;
                            for (Map.Entry<IWrapperEntity, IWrapperItemStack> entry : this.entityItems.entrySet()) {
                                if (entry.getValue() != dropStack) continue;
                                this.world.removeItemStackEntity(entry.getKey());
                            }
                        }
                        if (!crate.inventory.addStack(dropStack)) continue;
                        iterator.remove();
                        continue block24;
                    }
                }
                if (((JSONPart)this.definition).effector.type != JSONPart.EffectorComponentType.COLLECTOR) {
                    for (IWrapperItemStack dropStack : this.drops) {
                        this.world.spawnItemStack(dropStack, this.position, null);
                    }
                }
                this.drops.clear();
            }
            if (this.activatedThisTick) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEffector(this, false));
            }
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.linkedPullableCrates.clear();
        this.linkedParts.forEach(part -> {
            if (part instanceof PartInteractable && ((JSONPart)part.definition).interactable.interactionType == JSONPart.InteractableComponentType.CRATE) {
                this.linkedPushableCrates.add((PartInteractable)part);
                if (((JSONPart)part.definition).interactable.feedsVehicles) {
                    this.linkedPullableCrates.add((PartInteractable)part);
                }
            }
        });
        if (this.entityOn instanceof PartInteractable) {
            PartInteractable interactable = (PartInteractable)this.entityOn;
            if (((JSONPart)interactable.definition).interactable.interactionType == JSONPart.InteractableComponentType.CRATE) {
                this.linkedPushableCrates.add(interactable);
                if (((JSONPart)interactable.definition).interactable.feedsVehicles) {
                    this.linkedPullableCrates.add(interactable);
                }
            }
        }
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "effector_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.isActive ? 1.0 : 0.0, true);
            }
            case "effector_operated": {
                return new ComputedVariable(this, variable, partialTicks -> this.activatedThisTick ? 1.0 : 0.0, true);
            }
            case "effector_drill_broken": {
                return new ComputedVariable(this, variable, partialTicks -> this.blocksBroken, true);
            }
            case "effector_drill_max": {
                return new ComputedVariable(this, variable, partialTicks -> ((JSONPart)this.definition).effector.drillDurability, false);
            }
            case "effector_drill_percentage": {
                return new ComputedVariable(this, variable, partialTicks -> (double)this.blocksBroken / (double)((JSONPart)this.definition).effector.drillDurability, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("blocksBroken", this.blocksBroken);
        return data;
    }
}

